package gov.va.vinci.dart.db;

import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.DocumentReviewNote;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.dms.biz.Document;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestDocumentReviewNoteDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		
		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);
		
		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);
		
		List<DocumentTemplate> dtList = DartObjectFactory.getInstance().getDocumentTemplateDAO().listAll();
		Assert.assertNotNull(dtList);
		Assert.assertTrue(dtList.size() > 0);
		
		DocumentTemplate template = dtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Person pers = DartObjectFactory.getInstance().getPersonDAO().findById(1006);
		Assert.assertNotNull(pers);
		Assert.assertTrue(pers.getId() > 0);
		Assert.assertNotNull(pers.getGroups());
		Assert.assertTrue(pers.getGroups().size() > 0);
		
		Group group = pers.getGroups().iterator().next();
		Assert.assertNotNull(group);
		Assert.assertTrue(group.getId() > 0);
		
		Document doc = Document.create(request, template, pers.getName());
		Assert.assertNotNull(doc);
		Assert.assertTrue(doc.getId() > 0);
		
		DocumentReviewNote note = DocumentReviewNote.create(doc, "document review text", pers.getName(), group);
		Assert.assertNotNull(note);
		Assert.assertTrue(note.getId() > 0);

		DocumentReviewNote note2 = DartObjectFactory.getInstance().getDocumentReviewNoteDAO().findById(doc.getId(), pers.getName());
		Assert.assertNotNull(note2);
		Assert.assertEquals(note2, note);
		
		List<DocumentReviewNote> drnList = DartObjectFactory.getInstance().getDocumentReviewNoteDAO().listByReviewerId(pers.getName(), doc.getId(), group.getId());
		Assert.assertNotNull(drnList);
		Assert.assertTrue(drnList.size() > 0);
		Assert.assertTrue(drnList.contains(note));

	}
	
}
